#ifndef MSCANDRV_H
#define MSCANDRV_H           
/******************************************************************************
*                                                       
*       Copyright (C) 2008 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     msCANdrv.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    General header file for msCAN driver
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/****************************************************************************** 
 * Include
 ******************************************************************************/

#include "msCANstd.h"

/******************************************************************************
 * Identifier types
 ******************************************************************************/
#define STANDARD  0                                 /* IDE clear */
#define EXTENDED  0x18                                /* set SRR and IDE */
#define IDE_MASK       0x08                                /* IDE bit */
#define ERTR_MASK      0x01                                /* RTR bit for Extended ID */
#define SRTR_MASK      0x10                                /* RTR bit for Standard ID */

#define DATAFRAME 0                                 /* RTR clear */

/******************************************************************************
 * Clock source specifiers
 ******************************************************************************/
#define BUSCLK     1                                /* bit values for CLKSRC */
#define MCGERCLK   0

/******************************************************************************
 * MSCAN Enable
 ******************************************************************************/
#define MSCAN_ENABLE 1


/******************************************************************************
 * Transmit Buffer specifiers
 ******************************************************************************
#define TX_BUFF0 0x01
#define TX_BUFF1 0x02
#define TX_BUFF2 0x04         */

/******************************************************************************
 * Acceptance filter size: CANIDAC value
 ******************************************************************************/
#define AF32BIT  0x00
#define AF16BIT  0x10
#define AF8BIT   0x20
#define AFCLOSED 0x30

/******************************************************************************
 * word typedef
 ******************************************************************************/
typedef union
{
      UINT16 word;
      struct
      {
            UINT8 upper;
            UINT8 lower;
      }byte;
}wordType;

/******************************************************************************
 * Enumerations
 ******************************************************************************/
enum ResetMode { CMPTX,        /* 0 */
                 FAST          /* 1 */
               };

enum ErrorCode { ERR_OK,       /* 0 */
                 ERR_MODE,     /* 1 */
                 ERR_CAN,      /* 2 */
                 ERR_INIT,     /* 3 */
                 ERR_BOFF,     /* 4 */
                 ERR_NSLP,     /* 5 */
                 ERR_ID,       /* 6 */
                 ERR_MB,       /* 7 */
                 ERR_DLC,      /* 8 */
                 ERR_CONFIG,   /* 9 */
                 ERR_QED,      /* 10 */
                 ERR_NOTQED,   /* 11 */
                 ERR_NODATA,   /* 12 */
                 ERR_SYNCH,    /* 13 */
                 ERR_TS        /* 14 */
               };

enum MB_Mode   { CLOSED,       /* 0 */
                 RXDF,         /* 1 */
                 TXDF,         /* 2 */
                 TXRF,         /* 3 */
                 AUTOTXDF,     /* 4 */
                 INVALID
               };

enum MB_Status { NODATA,          /* 0 */
                 VALIDDATA,       /* 1 */
                 QUEUED,          /* 2 */
                 QUEUED2,         /* 3 */
                 ABORTREQ,        /* 4 */
                 ABORTED,         /* 5 */
                 TRANSMITTED,     /* 6 */        /* this value onwards valid status for ReadTimeMB */
                 NEWDATA,         /* 7 */
                 READDATA,        /* 8 */
                 OVERRUN          /* 9 */
               };

enum Version   { MSCANS08_01,
                 MSCANMCF51_01

               };

/******************************************************************************
 * Prototypes
 ******************************************************************************/
UINT8 CAN_Init                          (UINT8);
UINT8 CAN_Reset                         (UINT8);
UINT8 CAN_Sleep                         (UINT8);
UINT8 CAN_Wakeup                        (void);
UINT8 CAN_CheckStatus                   (UINT16 *);
UINT8 CAN_ClearStatus                   (void);
UINT8 CAN_ConfigMB                      (UINT8, UINT8, UINT8);
UINT8 CAN_CheckStatusMB                 (UINT8, UINT8 *);
UINT8 CAN_LoadMB                        (UINT8, UINT8 *);
UINT8 CAN_TransmitMB                    (UINT8);
UINT8 CAN_AbortMB                       (UINT8);
UINT8 CAN_ReadDataMB                    (UINT8, UINT8 *);
UINT8 CAN_ReadTimeMB                    (UINT8, UINT16 *);
UINT8 CAN_ReadMB                        (UINT8, UINT8 *);
UINT8 CAN_GetVersion                    (void);

/*****************************************************************************/
#endif        /* end msCANdrv.h */

